/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.model.IntegerOrBlockReference;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.ProtectionParameter;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.IntValueProperties;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;

public class CounterParameter
extends ProtectionParameter {
    private static final int MAX_DELTA = 999999;
    private static final int MIN_DELTA = 0;
    static final long serialVersionUID = 0L;
    private int counterParameterSerializedDataVersion = 3;
    protected int fLim;
    protected int fCount;
    protected boolean fCnt_old;
    protected int fMin = 0;
    protected int fMax = 99999;
    boolean fLongCounter = true;
    protected IntegerOrBlockReference fOff;
    protected IntegerOrBlockReference fOn;
    protected int fStartValue = 0;
    private String fMode;
    private static final String MODE_COUNTER_TWO_LIMES = "twoLimes";
    private static final String MODE_COUNTER_LIMES = "oneLimes";

    public CounterParameter() {
    }

    public CounterParameter(Block block) {
        super(block);
        WiringDiagram wd = block.getWiringDiagram();
        if (wd != null) {
            this.setLongCounter(wd.getHardware().supports("longCounter"));
        }
        this.fParameter = 2;
        this.fData = 2;
        this.fAllocatedTimer = 0;
        this.fCnt_old = false;
        this.fCount = 0;
    }

    public String calculateCurrentParameterText() {
        String value = Integer.toString(this.fCount);
        value = "      ".substring(value.length()) + value;
        return value;
    }

    protected boolean calculateValueLimes(boolean r, boolean cnt, boolean dir) {
        boolean ret;
        if (!this.fCnt_old && cnt) {
            this.updateCount(dir);
        }
        this.fCnt_old = cnt;
        boolean bl = ret = this.fCount >= this.fLim;
        if (r) {
            this.fCount = 0;
            ret = false;
        }
        return ret;
    }

    protected boolean calculateValueTwoLimes(boolean r, boolean cnt, boolean dir) {
        boolean ret;
        if (r) {
            this.fCount = this.getStartValueInt();
            this.fLastBinaryValue = false;
        } else if (!this.fCnt_old && cnt) {
            this.updateCount(dir);
        }
        this.fCnt_old = cnt;
        int on = this.fOn.getValue(0, 999999);
        int off = this.fOff.getValue(0, 999999);
        if (on >= off) {
            ret = this.fCount >= on ? true : this.fLastBinaryValue && this.fCount >= off;
            this.fLastBinaryValue = ret;
        } else {
            ret = this.fCount < off && this.fCount >= on;
        }
        return ret;
    }

    private void updateCount(boolean dir) {
        if (!dir) {
            ++this.fCount;
            if (this.fCount > this.fMax) {
                this.fCount = this.fMax;
            }
        } else {
            --this.fCount;
            if (this.fCount < this.fMin) {
                this.fCount = this.fMin;
            }
        }
    }

    private int getStartValueInt() {
        if (this.isSupportStartValue()) {
            return this.fStartValue;
        }
        return 0;
    }

    public IntValueProperties getLim() {
        return new IntValueProperties(this.fMin, this.fMax, 1, this.fLim, "error.dialog.invalidValue", "Invalid Value.");
    }

    public void setCurrentValue(IntValueProperties intValueProperties) {
        this.fCount = intValueProperties.getCurrentValue();
    }

    public IntValueProperties getCurrentValue() {
        return new IntValueProperties(this.fMin, this.fMax, 1, this.fCount, "error.dialog.invalidValue", "Invalid Value.");
    }

    public String getParameterText() {
        if (this.getMode().equals(MODE_COUNTER_LIMES)) {
            return this.getLimValue() + this.getProtectionSign() + "\n" + super.getParameterText();
        }
        StringBuffer result = new StringBuffer(30);
        result.append(this.getRemanenceObject().getParameterText()).append("\n").append("On=").append(this.getOn().getParameterText()).append(this.getProtectionSign()).append("\n").append("Off=").append(this.getOff().getParameterText());
        if (this.isSupportStartValue()) {
            result.append("\n").append("Start=").append(this.fStartValue);
        }
        return result.toString();
    }

    public boolean getValue(boolean r, boolean cnt, boolean dir) {
        boolean result = this.getMode().equals(MODE_COUNTER_TWO_LIMES) ? this.calculateValueTwoLimes(r, cnt, dir) : this.calculateValueLimes(r, cnt, dir);
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        this.fireParameterUpdateEvent();
        return result;
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        if (!this.getRemanenceAvailable() || !this.getRemanenceObject().getRemanence() || forceReset) {
            this.fCnt_old = false;
            this.fCount = this.fStartValue;
        }
    }

    public boolean isLongCounter() {
        return this.fLongCounter;
    }

    public boolean isLongCounterNeeded() {
        if (this.getMode().equals(MODE_COUNTER_LIMES)) {
            return this.fLim > 9999;
        }
        return this.fOn.getValue() > 9999;
    }

    public boolean isAvailable(Hardware hw, List errorList) {
        boolean result = super.isAvailable(hw, errorList);
        if (this.isLongCounterNeeded() && !hw.supports("longCounter")) {
            errorList.add(new ErrorInfo(this, "error.convert.counter.longCounter", hw));
            result = false;
        }
        if (this.getOn().getIntValueProperties().getCurrentValue() != this.getOff().getIntValueProperties().getCurrentValue() && !hw.supports(MODE_COUNTER_TWO_LIMES)) {
            errorList.add(new ErrorInfo(this, "error.convert.counterTwoLimes", hw));
            result = false;
        }
        if (this.fStartValue != 0 && !hw.supports("counter_startValue")) {
            errorList.add(new ErrorInfo(this, "error.convert.counter.startValue", hw));
            result = false;
        }
        return result;
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fLim = dr.readInt();
        this.fCount = dr.readInt();
        this.fCnt_old = dr.readBoolean();
        this.fMin = dr.readInt();
        this.fMax = dr.readInt();
        this.fLongCounter = dr.readBoolean();
        IntegerOrBlockReference on = (IntegerOrBlockReference)dr.readStorable();
        IntegerOrBlockReference off = (IntegerOrBlockReference)dr.readStorable();
        if (on != null) {
            this.fOn = on;
            this.fOff = off;
        }
        this.fStartValue = dr.readInt();
        this.fMode = dr.readString();
    }

    public final void setLim(int lim) {
        this.fLim = lim;
    }

    public void setLongCounter(boolean state) {
        this.fLongCounter = state;
        if (state) {
            this.fMax = 999999;
            this.setRemanenceAvailable(true);
        } else {
            this.fMax = 9999;
            this.setRemanenceAvailable(false);
        }
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fLim);
        dw.writeInt(this.fCount);
        dw.writeBoolean(this.fCnt_old);
        dw.writeInt(this.fMin);
        dw.writeInt(this.fMax);
        dw.writeBoolean(this.fLongCounter);
        dw.writeStorable(this.fOn);
        dw.writeStorable(this.fOff);
        dw.writeInt(this.fStartValue);
        dw.writeString(this.getMode());
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this.counterParameterSerializedDataVersion < 2) {
            this.counterParameterSerializedDataVersion = 2;
            this.fMode = MODE_COUNTER_LIMES;
        }
        if (this.counterParameterSerializedDataVersion < 3) {
            this.counterParameterSerializedDataVersion = 3;
        }
    }

    public int getLimValue() {
        return this.fLim;
    }

    public IntegerOrBlockReference getOff() {
        if (this.fOff == null) {
            this.fOff = new IntegerOrBlockReference(this);
            this.fOff.setIntValueProperties(new IntValueProperties(this.fMin, this.fMax, 1, 0, "error.counter2Limes.offValue", "Error input off-limit"));
        }
        return this.fOff;
    }

    public IntegerOrBlockReference getOn() {
        if (this.fOn == null) {
            this.fOn = new IntegerOrBlockReference(this);
            this.fOn.setIntValueProperties(new IntValueProperties(this.fMin, this.fMax, 1, 0, "error.counter2Limes.onValue", "Error input on-limit"));
        }
        return this.fOn;
    }

    public void setCurrent(int intValue) {
        this.fCount = intValue;
    }

    public void setOff(IntegerOrBlockReference off) {
        this.fOff.setValue(off);
    }

    public void setOn(IntegerOrBlockReference on) {
        this.fOn.setValue(on);
    }

    public IntValueProperties getStartValue() {
        return new IntValueProperties(0, 999999, 1, this.fStartValue, "error.dialog.invalidValue", "Invalid value.");
    }

    public void setStartValue(IntValueProperties startValue) {
        if (this.isSupportStartValue()) {
            this.fStartValue = startValue.getCurrentValue();
        } else {
            System.out.println("Error in Counter. Do not support start value setting.");
        }
    }

    public void hardwareChanged(HardwareChangedEvent hardwareChangedEvent) {
        super.hardwareChanged(hardwareChangedEvent);
        Hardware newHardware = (Hardware)hardwareChangedEvent.getNewValue();
        String newMode = this.getMode(newHardware);
        if (!this.getMode().equals(newMode)) {
            this.fMode = newMode;
            if (newMode.equals(MODE_COUNTER_TWO_LIMES)) {
                int value = this.getLimValue();
                this.getOn().setIntValue(value);
                this.getOff().setIntValue(value);
            } else {
                this.setLim(this.getOn().getValue());
            }
            this.fireParameterSetEvent();
        }
    }

    private String getMode() {
        if (this.fMode == null) {
            WiringDiagram wd = this.getBlock().getWiringDiagram();
            this.fMode = wd != null ? this.getMode(wd.getHardware()) : MODE_COUNTER_LIMES;
        }
        return this.fMode;
    }

    private String getMode(Hardware hardware) {
        String newMode = hardware.supports(MODE_COUNTER_TWO_LIMES) ? MODE_COUNTER_TWO_LIMES : MODE_COUNTER_LIMES;
        return newMode;
    }

    private boolean isSupportStartValue() {
        return this.getBlock().getWiringDiagram().getHardware().supports("counter_startValue");
    }
}

